package test;

/**
 * Write a description of class Test here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Scanner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;

import music.AcousticRockSong;
import music.Album;
import music.Artist;
import music.Author;
import music.EmptyPlaylistException;
import music.Performer;
import music.Playlist;
import music.RockSong;
import music.Song;
import util.Utility;

public class Test {
    
    public static final Scanner IN = new Scanner(System.in);
    
    public void tryOutJava() {
        System.out.println("Like a Rolling Stone");
        System.out.println();
        System.out.print("Read a line: ");
        String s = Test.IN.nextLine();
        System.out.println();
        System.out.println("You entered: " + s);
    }
    
    public void testSongs() {
        
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song();
        
//         likeARollingStone.title = "yj"      // No way! title is private
        likeARollingStone.setTitle("Like a Rolling Stone");
//         System.out.println(likeARollingStone.getTitle());
//         likeARollingStone.setAuthor("Bob Dylan");
        likeARollingStone.setAuthor(bobDylan);
        likeARollingStone.setYear(1965);
        likeARollingStone.display();
    }
    
    public void testSongsWithLoops() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song();
        
        likeARollingStone.setTitle("Like a Rolling Stone");
//         System.out.println(likeARollingStone.getTitle());
        likeARollingStone.setAuthor(bobDylan);
        likeARollingStone.setYear(1965);
//         likeARollingStone.title = "yj"      // No way! title is private
        for (int i = 0; i < 3; i++) {
            likeARollingStone.display();

        }
    }
    
    public void testConstructors() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song lrs = new Song();
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song balladOfAThinMan = new Song("Ballad of a Thin Man");
    }
    
    public void testArrays() {
        
//         double [] d = new double[3];
//         for (int i = 0; i < d.length; i++) {
// //             System.out.print("Read a double: ");
// //             d[i] = IN.nextDouble();
//             d[i] = 3.4 + i;
//             if (i == 1) {
// //                 break;
//                 continue;
//             }
//             System.out.println(d[i]);
//         }
        
        int [] a = {3, 10, -23};
        
        int i = 0;
//         while (i < a.length) {
//             System.out.println(a[i]);
//             i++;
//         }
        
//         do {
//             System.out.println(a[i]);
//             i++;
//         } while (i < a.length);

        final int j = 67;
        
//         j = 45;

        final Song s = new Song();
        s.setTitle("dfh");

        for (int k = 0; k < a.length; k++) {
            switch (k) {
                case 0: break;
                case 1: System.out.println("i = 1"); break;
                case 2: break;
            }
            System.out.println(a[k]);
        }
    }
        
    public void testobjectsWithObjectFields() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        System.out.println("Done");
    }
    
    public void testobjectsWithObjectArrayFields() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Performer dylan = new Performer("Bob Dylan", true);
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song balladOfAThinMan = new Song("Ballad of a Thin Man", bobDylan, 1965);
//         Song [] = new Song[3];
        Song [] songs = {likeARollingStone, desolationRow, balladOfAThinMan};
        Album h61 = new Album("Highway 61 Revisited", dylan, songs);
        System.out.println("Done");
    }
    
    public void testStatic() {
        Author bobDylan = new Author("Bob Dylan", "US", 75);
//         Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965, "A piece of music");
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
    }
    
    public void testNumberFormatting() {
    	double d = 3.46;
    	double d1 = 4.56778;
    	
    	System.out.println(d/d1);
    	
    	NumberFormat nf = NumberFormat.getInstance();
    	nf.setMaximumFractionDigits(2);
    	
    	System.out.println(nf.format(d/d1));
    	
    }
    
    public void testGregorianCalendar() {
    	GregorianCalendar today = new GregorianCalendar();
    	System.out.println(today.getTime());
    	
    	GregorianCalendar d1 = new GregorianCalendar(2012, 10, 4);
    	GregorianCalendar d2 = new GregorianCalendar(2012, 10, 4, 3, 45, 34);
    	System.out.println("d1: " + d1.getTime());
    	System.out.println("d2: " + d2.getTime());
    	System.out.println();
    	
        Author bobDylan = new Author("Bob Dylan", "US", 75);
        Performer dylan = new Performer("Bob Dylan", false);

        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        Song desolationRow = new Song("Desolation Row", bobDylan, 1965);
        Song queenJaneApproximately = new Song("Queen Jane Approximately", bobDylan, 1965);
        Song [] songs = {likeARollingStone, desolationRow, queenJaneApproximately};

        GregorianCalendar releaseDate = new GregorianCalendar(1965, 7, 30);
        Album h61 = new Album("Highway 61 Revisited", dylan, songs, releaseDate);
        System.out.println(
        		"Highway 61 Revisited, released: " + 
        				h61.getReleaseDate().getTime());
        
//        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        System.out.println(
        		df.format(h61.getReleaseDate().getTime()));
        
    	if (today.before(releaseDate)) {
    		System.out.println("Before");
    	} else {
    		System.out.println("After");
    	}
    }
    
    public void testStrings() {
    	String keithRichards = "Keith";
    	System.out.println(keithRichards);
    	
    	System.out.println(keithRichards.concat(" Richards").concat(", UK"));
    	System.out.println("".concat("Keith"));
    	
    	char [] keith = keithRichards.toCharArray();
    	for (int i = 0; i < keith.length; i++) {
			System.out.print(keith[i]);
		}
    	System.out.println();
    	
    	if (keith[0] == keithRichards.charAt(0)) {
    		System.out.println("The same char");
    	} else {
    		System.out.println("Not the same...");
    	}
    	
    	System.out.println(keithRichards.substring(0, 2));
    	
    	System.out.println();
    	
    	StringBuffer mickJagger = new StringBuffer();
    	mickJagger.append("Mick ");
    	mickJagger.append("Jagger");
    	mickJagger.append("is one of the greatest vocalists of all times!");
    }
    
    public void testInheritance() {
    	Author bobDylan = new Author("Bob Dylan", "US", 75);
        Song likeARollingStone = new Song("Like a Rolling Stone", bobDylan, 1965);
        likeARollingStone.display();
        
        System.out.println();
        
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);
        RockSong purpleHaze = new RockSong("Purple Haze", jimiHendrix, 1967, "legendary", 1);
        purpleHaze.display();
        
        System.out.println();
        
        Author howeGelb = new Author("Howe Gelb", "US", 56);
        AcousticRockSong heaventually = new AcousticRockSong("Heaventually", howeGelb, 2015, "a beautiful song", 3);
        heaventually.display();
        
        Song [] songs = {likeARollingStone, purpleHaze, heaventually};
    }
    
    public void testObject() {
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);
        RockSong purpleHaze = new RockSong("Purple Haze", jimiHendrix, 1967, "legendary", 1);
        System.out.println(purpleHaze.getTitle());
        System.out.println(purpleHaze);
        
        RockSong pH = new RockSong("Purple Haze", jimiHendrix, 1967, "legendary", 1);
        if (pH.equals(purpleHaze)) {
        	System.out.println("The same song");
        } else {
        	System.out.println("Different songs");
        }
    }
    
    public void testInterfaces() {
    	Artist keithRichards = new Author("Keith Richards", "UK", 72, "r'n'r");
    	keithRichards.displayID();
    	if (keithRichards.isDeceased()) {
    		System.out.println("Deceased, unfortunately...");
    	} else {
    		System.out.println("Still crazy, after all these years!");
    	}
    	
    	System.out.println();
    	
    	Artist theRollingStones = new Performer("The Rolling Stones", true);
    	theRollingStones.displayID();
    	
//    	theRollingStones.getName(); // no way
    	
    	System.out.println();
    	
    	ArrayList<Artist> artists = new ArrayList<Artist>();
    	artists.add(keithRichards);
    	artists.add(theRollingStones);
    	for (int i = 0; i < artists.size(); i++) {
			artists.get(i).displayID();
			System.out.println();
//			artists.remove(i);
		}
    }
    
    public void testNullPointerException() {
        String s = null;
        s.length();
    }
    
    public void testLinkedList() {
    	
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);

    	Playlist playlist = new Playlist();
    	try {
			playlist.playAll();
		} catch (EmptyPlaylistException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
//			System.exit(1);
		}
    	
    	Song heyJoe = new Song("Hey Joe", jimiHendrix, 1967);
    	Song purpleHaze = new Song("Purple Haze", jimiHendrix, 1967);
    	Song areYouExperienced = new Song("Are You Experienced", jimiHendrix, 1967);
    	
    	playlist.addSong(heyJoe);
    	playlist.addSong(purpleHaze);
    	playlist.addSong(areYouExperienced);
    	try {
			playlist.playAll();
		} catch (EmptyPlaylistException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	System.out.println();
    	
    	playlist.addSong(new Song("Little Wing", jimiHendrix, 1967));
    	try {
			playlist.playAll();
		} catch (EmptyPlaylistException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	System.out.println();
    	
//        playlist.removeSong(2);
        playlist.removeSong(purpleHaze);
    	try {
			playlist.playAll();
		} catch (EmptyPlaylistException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
    public void testTextFiles() {
        Song heyJoe = new Song("Hey Joe");
        Song areYouExperienced = new Song("Are You Experienced");
        Song purpleHaze = new Song("Purple Haze");
        
        File f = new File("Songs.txt");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            out.println(heyJoe.getTitle());
            out.println(areYouExperienced.getTitle());
            out.println(purpleHaze.getTitle());
            out.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        Song [] songs = new Song[3];
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            for (int i = 0; i < songs.length; i++) {
                songs[i] = new Song(in.readLine());
            }
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        for (int i = 0; i < songs.length; i++) {
            if (songs[i] != null) {
                System.out.println(songs[i].getTitle());
            }
        }
    }
    
    public void testSerialization() {
        Author jimiHendrix = new Author("Jimi Hendrix", "US", -1);
        Song purpleHaze = new Song("Purple Haze", jimiHendrix, 1967);
        purpleHaze.serialize("Purple Haze");
    }
    
    public void testDeserialization() {
        Song purpleHaze = Song.deserialize("Purple Haze");
        purpleHaze.display();
    }
    
    public void testAbsPath() {
    	Utility.getProjectDir();
    }
    
}
